set Release(connect.tcl) {$Header: /home/cvs/tktest/connect.tcl,v 1.6 2004/09/02 18:43:57 clif Exp $}

###################################################################
# ChangeCursor: change the mouse cursor for the main window.
###################################################################
proc ChangeCursor {cursorName} {
    #
    # USER OPTION: change this body to return {} to prevent
    # the cursor from being changed.
    #
    set oldCursor [.replay cget -cursor]
    .replay configure -cursor $cursorName
    return $oldCursor
}
###################################################################
# MonitorApps: find the names of all existing interpeters.
#   We also check to be see if any of the interpreters we are
#   connected to have quit.
#
#   This proc calls itself (using after) every 3 seconds.
###################################################################
proc MonitorApps {} {
    global ReplayData
    
    return;
    # This is superfluous with the socket-only paradigm.
    #  We'll learn an app has died when the socket dies.

    set ReplayData(ExistingApps) [lsort [winfo interps]]

    # add on any connected by sockets
    foreach interp $ReplayData(SocketApps) {
      lappend ReplayData(ExistingApps) $ReplayData(SocketApps)
    }

    #
    # see if any of our connected apps have quit
    #
    set cl {}
    set wasChanged 0

    foreach app $ReplayData(ConnectedApps) {
        if {[lmember $app $ReplayData(ExistingApps)]} {
            lappend cl $app
        } else {
            # inform the user that a connected application has quit.
            MsgToUser "Connected application \"$app\" has exited." low
            set wasChanged 1
        }
    }
    #
    # update the display if any changed have occurred.
    #
    if {$wasChanged} {
        set ReplayData(ConnectedApps) [lsort $cl]
        if {$cl == {}} {
            set list "<None>"
        } else {
            set list $ReplayData(ConnectedApps)
        }
    }
    #
    # USER OPTION: you can change the interval at which we check for
    #   applications that have started or exited
    #
    after 3000 MonitorApps
}
###################################################################
# FillConnectMenu: refill the menu of existing Tcl apps.
###################################################################
proc FillConnectMenu {menu} {
    global ReplayData
    $menu delete 0 last
    set interps ""
# puts "START FillConnectMenu -- ..$ReplayData(SocketApps).."
    # add on any connected by sockets
    foreach interp $ReplayData(SocketApps) {
        # only add it if it is not already on the list
        if {[lsearch -exact $interps $interp] < 0} {
            lappend interps $interp
        }
    }

    # get the list of active interpreter from winfo if local
    if {[string equal "" [string trim $ReplayData(SocketApps)]]} {
      set interps [winfo interps]
    }
# puts "INTERPS: ..$ReplayData(SocketApps).. [string equal {} [string trim $ReplayData(SocketApps)]] -- $interps"
    foreach interp [lsort $interps] {
        $menu add command -label $interp -command [list ConnectToApp $interp]
    }
}
###################################################################
# ConnectToApp: connect to the application.
###################################################################
proc ConnectToApp {app} {
    global ReplayData

    # only connect once.
    if {[lmember $app $ReplayData(ConnectedApps)]} {
        MsgToUser "Already connected to \"$app\"" low
        return
    }
    MsgToUser "Connecting to \"$app\". Please wait ..."
    # connecting can take a while so put up a wait cursor.
    set oldCursor [ChangeCursor watch]
    #
    # Set up some initial data in the target application.
    # This is our bootstrap data.
    #
    SendToApp $app [format {global db__rd;set db__rd(ReplayApp) {%s}} \
        $ReplayData(ThisApp)]
    #
    # Now send the "rebind.tcl" file to do the heavy work.
    #

    set if [open rebind.tcl r]
    set d [read $if]
    close $if

    SendToApp $app "$d"

    if {$ReplayData(RecordingOn)} {
        InsertAction 0 ThisApp ConnectToApp $app
    }
    ChangeCursor $oldCursor
    MsgToUser "Connected to \"$app\" recording or replaying"
    lappend ReplayData(ConnectedApps) $app
    set ReplayData(Status) Connected
}
###################################################################
# SendToApp: send to the application (and get reply unless asynchronous).
###################################################################
proc SendToApp {app cmd {async ""}} {
    global ReplayData
    if {$async != ""} {
        set err [catch [list tkrsend -async $app $cmd] ret]
    } else {
        set err [catch [list tkrsend $app $cmd] ret]
    }
    if $err {
        if {[lmember $app $ReplayData(ConnectedApps)]} {
            MsgToUser "Send to $app ($cmd) failed: $ret" medium
        } else {
            MsgToUser "Send failed: not connected to $app ($ret)" low
        }
        return ""
    } else {
        return $ret
    }
}
###################################################################
# QuitReplay: exit the program.
###################################################################
proc QuitReplay {} {
    exit
}
###################################################################
# lmember: a utility procedure that determines if a string is a
#    member of a list.  Useful when we are using lists as sets.
###################################################################
proc lmember {item list} {
    if {[lsearch -exact $list $item] >= 0} {
        return 1
    } else {
        return 0
    }
}
